/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.mininglevel;

import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.event.lifecycle.v1.CommonLifecycleEvents;
import net.minecraft.class_2680;
import net.minecraft.class_3481;
import net.minecraft.class_6862;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MiningLevelManagerImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"fabric-mining-level-api-v1/MiningLevelManagerImpl");
    private static final String TOOL_TAG_NAMESPACE = "fabric";
    private static final Pattern TOOL_TAG_PATTERN = Pattern.compile("^needs_tool_level_([0-9]+)$");
    private static final ThreadLocal<Reference2IntMap<class_2680>> CACHE = ThreadLocal.withInitial(Reference2IntOpenHashMap::new);

    public static int getRequiredMiningLevel(class_2680 state) {
        return CACHE.get().computeIfAbsent((Object)state, s -> {
            int miningLevel = -1;
            for (class_6862 tagId : state.method_40144().toList()) {
                Matcher matcher;
                if (!tagId.comp_327().method_12836().equals(TOOL_TAG_NAMESPACE) || !(matcher = TOOL_TAG_PATTERN.matcher(tagId.comp_327().method_12832())).matches()) continue;
                try {
                    int tagMiningLevel = Integer.parseInt(matcher.group(1));
                    miningLevel = Math.max(miningLevel, tagMiningLevel);
                }
                catch (NumberFormatException e) {
                    LOGGER.error("Could not read mining level from tag #{}", (Object)tagId, (Object)e);
                }
            }
            if (state.method_26164(class_3481.field_33717)) {
                miningLevel = Math.max(miningLevel, 3);
            } else if (state.method_26164(class_3481.field_33718)) {
                miningLevel = Math.max(miningLevel, 2);
            } else if (state.method_26164(class_3481.field_33719)) {
                miningLevel = Math.max(miningLevel, 1);
            }
            return miningLevel;
        });
    }

    static {
        CommonLifecycleEvents.TAGS_LOADED.register((registries, client) -> CACHE.get().clear());
    }
}

